﻿/*
	Include in output:

	This file is part of Natural Docs, which is Copyright © 2003-2022 Code Clear LLC.
	Natural Docs is licensed under version 3 of the GNU Affero General Public
	License (AGPL).  Refer to License.txt or www.naturaldocs.org for the
	complete details.

	This file may be distributed with documentation files generated by Natural Docs.
	Such documentation is not covered by Natural Docs' copyright and licensing,
	and may have its own copyright and distribution terms as decided by its author.
*/

"use strict";


/* Class: NDHomePage
	_____________________________________________________________________________

*/
var NDHomePage = new function ()
	{

	// Group: Functions
	// ________________________________________________________________________


	/* Function: Start
	*/
	this.Start = function ()
		{
		// Apply the theme
		var themeID = NDCore.GetQueryParam('Theme');

		if (themeID != undefined)
			{  NDThemes.Apply(themeID);  }

		// Set up event listener
		window.addEventListener("message", this.OnMessage);
		};


	/* Function: OnMessage

		Event handler for messages sent to this page by the frame page via postMessage().

		Supported Commands:

			NoTheme - Remove any theme classes.
			Theme=[id] - Apply the passed theme ID.
	*/
	this.OnMessage = function (event)
		{
		var message = event.data;

		if (message == "NoTheme")
			{  NDThemes.Apply(undefined);  }
		else if (message.StartsWith("Theme="))
			{
			var theme = message.slice(6);
			NDThemes.Apply(theme);
			}
		};

	};
